/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.eui;

import ibm.nways.jdm.JmaColors;
import ibm.nways.jdm.common.BadValue;
import ibm.nways.jdm.common.OctetString;
import ibm.nways.jdm.common.SpecialValue;
import ibm.nways.jdm.eui.HexInput;
import ibm.nways.jdm.eui.JDMInput;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.io.Serializable;
import java.util.ResourceBundle;

public class ATMAddressInput
extends Panel
implements JDMInput {
    protected Label networkLabel = new Label(ATMAddressInput.getNLSString("NetworkHeaderLabel"));
    protected HexInput networkValue = new HexInput("", 26);
    protected Label systemLabel = new Label(ATMAddressInput.getNLSString("SystemIdentifierLabel"));
    protected HexInput systemValue = new HexInput("", 12);
    protected Label selectorLabel = new Label(ATMAddressInput.getNLSString("SelectorByteLabel"));
    protected HexInput selectorValue = new HexInput("", 2);
    private static ResourceBundle myResources = null;
    protected int maxlength = Integer.MAX_VALUE;

    public ATMAddressInput() {
        this.networkLabel.setForeground(JmaColors.textText);
        this.systemLabel.setForeground(JmaColors.textText);
        this.selectorLabel.setForeground(JmaColors.textText);
        this.networkValue.setForeground(JmaColors.textText);
        this.systemValue.setForeground(JmaColors.textText);
        this.selectorValue.setForeground(JmaColors.textText);
        ((Component)this.networkValue).setBackground(JmaColors.background);
        ((Component)this.systemValue).setBackground(JmaColors.background);
        ((Component)this.selectorValue).setBackground(JmaColors.background);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.networkLabel, gridBagConstraints);
        gridBagLayout.setConstraints(this.systemLabel, gridBagConstraints);
        gridBagLayout.setConstraints(this.selectorLabel, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = -1;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.gridheight = 1;
        gridBagLayout.setConstraints(this.networkValue, gridBagConstraints2);
        gridBagLayout.setConstraints(this.systemValue, gridBagConstraints2);
        gridBagLayout.setConstraints(this.selectorValue, gridBagConstraints2);
        this.add(this.networkLabel);
        this.add(this.networkValue);
        this.add(this.systemLabel);
        this.add(this.systemValue);
        this.add(this.selectorLabel);
        this.add(this.selectorValue);
    }

    public String stringValue() {
        return String.valueOf(this.networkValue.hexValue()) + this.systemValue.hexValue() + this.selectorValue.hexValue();
    }

    public Object getValue() {
        return new OctetString(this.stringValue());
    }

    public String toString() {
        return this.stringValue();
    }

    public void setValue(Object object) {
        Serializable serializable;
        if (object instanceof OctetString) {
            serializable = (OctetString)object;
            this.setValue(serializable.toString());
        }
        if (object instanceof SpecialValue) {
            serializable = (SpecialValue)object;
            this.setErrorValue((SpecialValue)serializable);
        }
    }

    public void setValue(String string) {
        if (string.length() == 40) {
            this.networkValue.setValue(string.substring(0, 26));
            this.systemValue.setValue(string.substring(26, 38));
            this.selectorValue.setValue(string.substring(38));
            this.networkValue.setEditable(true);
            this.systemValue.setEditable(true);
            this.selectorValue.setEditable(true);
            return;
        }
        if (string.toString().equals("")) {
            this.networkValue.setValue("");
            this.systemValue.setValue("");
            this.selectorValue.setValue("");
            this.networkValue.setEditable(true);
            this.systemValue.setEditable(true);
            this.selectorValue.setEditable(true);
            return;
        }
        this.setErrorValue(new BadValue());
    }

    public void setErrorValue(SpecialValue specialValue) {
        this.networkValue.setValue(specialValue);
        this.systemValue.setValue("");
        this.selectorValue.setValue("");
        this.networkValue.setEditable(false);
        this.systemValue.setEditable(false);
        this.selectorValue.setEditable(false);
    }

    public boolean isValidValue() {
        if (this.networkValue.hasErrorValue) {
            return false;
        }
        return this.networkValue.isValidValue() && this.systemValue.isValidValue() && this.selectorValue.isValidValue();
    }

    public boolean ignoreValue() {
        return this.networkValue.ignoreValue();
    }

    protected static String getNLSString(String string) {
        try {
            if (myResources == null) {
                myResources = ResourceBundle.getBundle("ibm.nways.jdm.eui.ATMAddressInputResources");
            }
            if (myResources == null) {
                return string;
            }
            return myResources.getString(string);
        }
        catch (Exception exception) {
            return string;
        }
    }
}

